<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Search Rate Limiter by Amasty
 */

namespace Amasty\SearchRateLimiter\Plugin\ElasticSearchGraphQl\Model\Resolver;

use Amasty\ElasticSearchGraphQl\Model\Resolver\Product;
use Amasty\SearchRateLimiter\Model\RateLimiter;
use Magento\Framework\GraphQl\Config\Element\Field;
use Magento\Framework\GraphQl\Exception\GraphQlInputException;
use Magento\Framework\GraphQl\Schema\Type\ResolveInfo;

class LockProductSearch
{
    /**
     * @var RateLimiter
     */
    private $rateLimiter;

    public function __construct(
        RateLimiter $rateLimiter
    ) {
        $this->rateLimiter = $rateLimiter;
    }

    public function beforeResolve(
        Product $subject,
        Field $field,
        $context,
        ResolveInfo $info,
        array $value = null,
        array $args = null
    ): void {
        $rateLimiter = $this->rateLimiter->getLimiter(RateLimiter::SEARCH_LIMITER);
        if ($rateLimiter && !$rateLimiter->consume()->isAccepted()) {
            throw new GraphQlInputException(__('You have sent too many requests. Please try again later.'));
        }
    }
}
