<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Search Rate Limiter by Amasty
 */

namespace Amasty\SearchRateLimiter\Plugin\CatalogSearch\Controller\Result;

use Amasty\SearchRateLimiter\Model\RateLimiter;
use Magento\CatalogSearch\Controller\Result\Index;

class LockSearch
{
    /**
     * @var RateLimiter
     */
    private $rateLimiter;

    public function __construct(
        RateLimiter $rateLimiter
    ) {
        $this->rateLimiter = $rateLimiter;
    }

    public function aroundExecute(Index $subject, callable $proceed): void
    {
        $rateLimiter = $this->rateLimiter->getLimiter(RateLimiter::SEARCH_LIMITER);
        if ($rateLimiter && !$rateLimiter->consume()->isAccepted()) {
            $subject->getResponse()->setStatusHeader(429, '1.1', 'Too Many Requests');
        } else {
            $proceed();
        }
    }
}
