<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Search Rate Limiter by Amasty
 */

namespace Amasty\SearchRateLimiter\Model\System\Config\Backend;

use Magento\Framework\App\Config\Value;
use Magento\Framework\Exception\LocalizedException;
use Symfony\Component\Lock\LockFactory;
use Symfony\Component\RateLimiter\RateLimiterFactory;

class RateLimiter extends Value
{
    public function beforeSave(): void
    {
        if (!class_exists(RateLimiterFactory::class) || !class_exists(LockFactory::class)) {
            $this->setValue('0');
            throw new LocalizedException(__(
                'Symfony library \'symfony/rate-limiter\' or \'symfony/lock\' are not found. '
                . 'Please run \'composer require symfony/rate-limiter\' and \'composer require symfony/lock\''
                . ' commands to install them.'
            ));
        }
    }
}
