<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Search Rate Limiter by Amasty
 */

namespace Amasty\SearchRateLimiter\Model;

use Amasty\Base\Model\ConfigProviderAbstract;

class ConfigProvider extends ConfigProviderAbstract
{
    /**
     * @var string
     */
    protected $pathPrefix = 'amasty_xsearch/';

    public const SEARCH_REQUESTS_LIMITATION_ENABLED = 'search_requests_limitation/enabled';
    public const REQUESTS_LIMITATION_NUMBER = 'search_requests_limitation/requests_number';
    public const REQUESTS_LIMITATION_PERIOD = 'search_requests_limitation/limit_period';

    public function isSearchRequestsLimitationEnabled(): bool
    {
        return (bool)$this->getValue(self::SEARCH_REQUESTS_LIMITATION_ENABLED);
    }

    public function getRequestLimitationNumber(): int
    {
        return (int)$this->getValue(self::REQUESTS_LIMITATION_NUMBER) ?: 100;
    }

    public function getRequestLimitationPeriod(): int
    {
        return (int)$this->getValue(self::REQUESTS_LIMITATION_PERIOD) ?: 1;
    }
}
