<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Search Rate Limiter by Amasty
 */

namespace Amasty\SearchRateLimiter\Model\Cache;

use Amasty\SearchRateLimiter\Model\Cache\Type\RateLimiter;
use Magento\Framework\App\CacheInterface;
use Symfony\Component\RateLimiter\LimiterStateInterface;
use Symfony\Component\RateLimiter\Storage\StorageInterface;

class CacheStorage implements StorageInterface
{
    /**
     * @var CacheInterface
     */
    private $cache;

    public function __construct(
        CacheInterface $cache
    ) {
        $this->cache = $cache;
    }

    public function save(LimiterStateInterface $limiterState): void
    {
        $this->cache->save(
        // Not good solution. We have to use serialize.
        //phpcs:ignore
            call_user_func_array("serialize", [$limiterState]),
            $this->getIdentifier($limiterState->getId()),
            [RateLimiter::CACHE_TAG],
            $limiterState->getExpirationTime()
        );
    }

    public function fetch(string $limiterStateId): ?LimiterStateInterface
    {
        $data = $this->cache->load($this->getIdentifier($limiterStateId));
        if ($data) {
            // Not good solution. We have to use unserialize.
            //phpcs:ignore
            $data = call_user_func_array("unserialize", [$data]);
            if ($data instanceof LimiterStateInterface) {
                return $data;
            }
        }

        return null;
    }

    public function delete(string $limiterStateId): void
    {
        $this->cache->remove($this->getIdentifier($limiterStateId));
    }

    private function getIdentifier(string $limiter): string
    {
        return RateLimiter::TYPE_IDENTIFIER . '_' . $limiter;
    }
}
