<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Ajax Infinity Scroll Hyva Compatibility by Amasty
 */

namespace Amasty\ScrollHyva\ViewModel;

use Amasty\ScrollHyva\Model\ScrollConfigProvider;
use Magento\Framework\View\Element\Block\ArgumentInterface;

class Config implements ArgumentInterface
{
    /**
     * @var ScrollConfigProvider
     */
    private ScrollConfigProvider $scrollConfigProvider;

    public function __construct(
        ScrollConfigProvider $scrollConfigProvider
    ) {
        $this->scrollConfigProvider = $scrollConfigProvider;
    }

    public function getLoaderUrl(): string
    {
        return $this->scrollConfigProvider->getLoaderUrl();
    }
}
