<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Ajax Infinity Scroll Hyva Compatibility by Amasty
 */

namespace Amasty\ScrollHyva\Plugin\Ajax;

use Amasty\Scroll\Model\Source\Loading;
use Amasty\ScrollHyva\Model\ScrollConfigProvider;
use Hyva\Theme\Service\CurrentTheme;
use Magento\Catalog\Block\Product\ListProduct;
use Magento\Framework\App\Request\Http;
use Magento\Framework\View\Element\BlockInterface;

class ProductListWrapper
{
    /**
     * @var CurrentTheme
     */
    private CurrentTheme $currentTheme;

    /**
     * @var Http
     */
    private Http $request;

    /**
     * @var ScrollConfigProvider
     */
    private ScrollConfigProvider $scrollConfigProvider;

    public function __construct(
        Http $request,
        CurrentTheme $currentTheme,
        ScrollConfigProvider $scrollConfigProvider
    ) {
        $this->currentTheme = $currentTheme;
        $this->request = $request;
        $this->scrollConfigProvider = $scrollConfigProvider;
    }

    public function afterToHtml(ListProduct $subject, string $result): string
    {
        if (!$this->shouldAddInitBlock() || !$this->currentTheme->isHyva()) {
            return $result;
        }

        return $result . $this->getScrollBlock($subject)->toHtml();
    }

    private function getScrollBlock(ListProduct $block): ?BlockInterface
    {
        return $block->getLayout()->getBlock('amasty.scroll.init');
    }

    private function shouldAddInitBlock(): bool
    {
        return $this->scrollConfigProvider->getLoadingType() !== Loading::NONE
            && !$this->request->getParam('is_scroll')
            && $this->request->isAjax();
    }
}
