<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Ajax Infinity Scroll Hyva Compatibility by Amasty
 */

namespace Amasty\ScrollHyva\Model;

use Amasty\Base\Model\ConfigProviderAbstract;

class ScrollConfigProvider extends ConfigProviderAbstract
{
    public const LOADER = 'general/loader';

    public const LOADING_TYPE = 'general/loading';

    /**
     * @var string
     */
    protected $pathPrefix = 'amasty_scroll/';

    public function getLoaderUrl(?int $storeId = null): string
    {
        return (string)$this->getValue(self::LOADER, $storeId);
    }

    public function getLoadingType(?int $storeId = null): string
    {
        return (string)$this->getValue(self::LOADING_TYPE, $storeId);
    }
}
