<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Sales Reps and Dealers for Magento 2
 */
namespace Amasty\Perm\Observer;

use Magento\Framework\Event\ObserverInterface;
use \Amasty\Perm\Helper\Data as Helper;

class SalesOrderLoadAfterObserver implements ObserverInterface
{
    /**
     * @var Helper
     */
    private $_permHelper;

    public function __construct(
        Helper $permHelper
    ) {
        $this->_permHelper = $permHelper;
    }

    /**
     * @param \Magento\Framework\Event\Observer $observer
     * @return void
     */
    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        $order = $observer->getEvent()->getData('data_object');
        $this->_permHelper->checkPermissionsByOrder($order);
    }
}
