<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Sales Reps and Dealers for Magento 2
 */

namespace Amasty\Perm\Observer;

use Amasty\Perm\Helper\Data;
use Magento\Framework\Event\ObserverInterface;

class CustomerLoadAfterObserver implements ObserverInterface
{
    /**
     * @var Data
     */
    private $_permHelper;

    public function __construct(
        Data $permHelper
    ) {
        $this->_permHelper = $permHelper;
    }

    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        $customer = $observer->getEvent()->getData('data_object');
        $this->_permHelper->checkPermissionsByCustomerId($customer->getId());
    }
}
