<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Sales Reps and Dealers for Magento 2
 */

namespace Amasty\Perm\Model\ResourceModel;

use Amasty\Perm\Helper\Data;

class DealerCustomer extends \Magento\Framework\Model\ResourceModel\Db\AbstractDb
{
    public function __construct(
        \Magento\Framework\Model\ResourceModel\Db\Context $context,
        Data $helper = null, // @deprecated. Backward compatibility
        $connectionName = null
    ) {
        return parent::__construct($context, $connectionName);
    }
    protected function _construct()
    {
        $this->_init('amasty_perm_dealer_customer', 'entity_id');
    }

    public function getCustomers(\Amasty\Perm\Model\Dealer $dealer)
    {
        $connection = $this->getConnection();

        $binds = ['dealer_id' => $dealer->getId()];

        $select = $connection->select()
            ->from($this->getMainTable(), ['customer_id'])
            ->where('dealer_id = :dealer_id');

        return $connection->fetchCol($select, $binds);
    }
}
