<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Request a Quote GraphQl for Magento 2 (System)
 */

use Magento\TestFramework\Helper\Bootstrap;
use Magento\Store\Api\StoreRepositoryInterface;
use Amasty\RequestQuote\Api\QuoteRepositoryInterface;
use Amasty\RequestQuote\Api\Data\QuoteInterface;
use Magento\Quote\Model\QuoteIdMask;
use Magento\Quote\Model\ResourceModel\Quote\QuoteIdMask as QuoteIdMaskResource;
use Magento\TestFramework\Workaround\Override\Fixture\Resolver;

Resolver::getInstance()->requireDataFixture('Magento/Store/_files/second_website_with_two_stores.php');

$objectManager = Bootstrap::getObjectManager();

$storeRepository = $objectManager->get(StoreRepositoryInterface::class);
$store = $storeRepository->get('fixture_second_store');

$quoteRepository = $objectManager->create(QuoteRepositoryInterface::class);
$quote = $objectManager->create(QuoteInterface::class);

$quote->setIsActive(false)
    ->setReservedOrderId('test_order_222')
    ->setStoreId($store->getId())
    ->setQuoteCurrencyCode($store->getCurrentCurrencyCode());
$quoteRepository->save($quote);

$quoteIdMask = $objectManager->create(QuoteIdMask::class)
    ->setQuoteId($quote->getId())
    ->setDataChanges(true);
$quoteIdMaskResource = $objectManager->get(QuoteIdMaskResource::class);

$quoteIdMaskResource->save($quoteIdMask);
