<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Request a Quote GraphQl for Magento 2 (System)
 */

use Magento\TestFramework\Helper\Bootstrap;
use Amasty\RequestQuote\Api\QuoteRepositoryInterface;
use Amasty\RequestQuote\Api\Data\QuoteInterface;
use Magento\Store\Model\StoreManagerInterface;
use Magento\Quote\Model\QuoteIdMask;
use Magento\Quote\Model\QuoteIdMaskFactory;

$objectManager = Bootstrap::getObjectManager();

$quoteRepository = Bootstrap::getObjectManager()->create(QuoteRepositoryInterface::class);
$quote = $objectManager->create(QuoteInterface::class);

$storeManager = $objectManager->create(StoreManagerInterface::class);

$quote->setStoreId(1)
    ->setIsActive(false)
    ->setIsMultiShipping(0)
    ->setReservedOrderId('test_order_111')
    ->setQuoteCurrencyCode($storeManager->getStore(1)->getCurrentCurrencyCode());
$quoteRepository->save($quote);

/** @var QuoteIdMask $quoteIdMask */
$quoteIdMask = $objectManager->create(QuoteIdMaskFactory::class)->create();

$quoteIdMask->setQuoteId($quote->getId());
$quoteIdMask->setDataChanges(true);
$quoteIdMask->save();
