<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Request a Quote GraphQl for Magento 2 (System)
 */

use Magento\Customer\Api\CustomerRepositoryInterface;
use Magento\Customer\Model\CustomerRegistry;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Framework\Registry;
use Magento\TestFramework\Helper\Bootstrap;

$objectManager = Bootstrap::getObjectManager();

/** @var Registry $registry */
$registry = $objectManager->get(Registry::class);

/** @var CustomerRepositoryInterface $customerRepository */
$customerRepository = $objectManager->get(CustomerRepositoryInterface::class);

/** @var CustomerRegistry $customerRegistry */
$customerRegistry = $objectManager->get(CustomerRegistry::class);

$registry->unregister('isSecureArea');
$registry->register('isSecureArea', true);
try {
    $customer = $customerRepository->get('customer_quote@example.com');
    $customerRegistry->remove($customer->getId());
    $customerRepository->deleteById($customer->getId());
} catch (NoSuchEntityException $e) {
    //Customer already deleted.
}
$registry->unregister('isSecureArea');
$registry->register('isSecureArea', false);
