<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Request a Quote GraphQl for Magento 2 (System)
 */

use Amasty\RequestQuote\Model\Source\Status;
use Magento\Framework\DataObjectFactory;
use Magento\Framework\Event\ManagerInterface as EventManagerInterface;
use Magento\Quote\Model\Quote\Item as QuoteItem;
use Magento\TestFramework\Helper\Bootstrap;
use Amasty\RequestQuote\Api\QuoteRepositoryInterface;
use Amasty\RequestQuote\Model\QuoteFactory;
use Amasty\RequestQuote\Model\ResourceModel\Quote as QuoteResource;
use Magento\Framework\Stdlib\DateTime\DateTime;

$objectManager = Bootstrap::getObjectManager();

/** @var QuoteRepositoryInterface $quoteRepository */
$quoteRepository = $objectManager->create(QuoteRepositoryInterface::class);

/** @var QuoteFactory $quoteFactory */
$quoteFactory = $objectManager->get(QuoteFactory::class);

/** @var QuoteResource $quoteResource */
$quoteResource = $objectManager->get(QuoteResource::class);

/** @var EventManagerInterface $eventManager */
$eventManager = $objectManager->get(EventManagerInterface::class);

/** @var DataObjectFactory $dataObjectFactory */
$dataObjectFactory = $objectManager->get(DataObjectFactory::class);

/** @var DateTime $dateTime */
$dateTime = $objectManager->get(DateTime::class);

$quote = $quoteFactory->create();
$quoteResource->load($quote, 'test_order_active', 'reserved_order_id');

$eventManager->dispatch('amasty_request_quote_submit_before', ['quote' => $quote]);

/** @var QuoteItem $quoteItem */
foreach ($quote->getAllItems() as $quoteItem) {
    $priceOption = $dataObjectFactory->create(
        []
    )->setCode(
        'amasty_quote_price'
    )->setValue(
        $quoteItem->getPrice()
    )->setProduct(
        $quoteItem->getProduct()
    );
    $quoteItem->addOption($priceOption)->saveItemOptions();
}

$quote->setSubmitedDate($dateTime->gmtDate());
$quote->setStatus(Status::PENDING);
$quoteRepository->save($quote);

$eventManager->dispatch('amasty_request_quote_submit_after', ['quote' => $quote]);
