<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Request a Quote GraphQl for Magento 2 (System)
 */

use Amasty\RequestQuote\Api\QuoteManagementInterface;
use Magento\Customer\Api\CustomerRepositoryInterface;
use Magento\TestFramework\Helper\Bootstrap;
use Magento\Quote\Model\QuoteFactory;
use Magento\Quote\Model\ResourceModel\Quote as QuoteResource;
use Amasty\RequestQuote\Model\QuoteFactory as RequestQuoteFactory;
use Amasty\RequestQuote\Model\ResourceModel\Quote as RequestQuoteResource;

$objectManager = Bootstrap::getObjectManager();

/** @var QuoteFactory $quoteFactory */
$quoteFactory = $objectManager->get(QuoteFactory::class);

/** @var RequestQuoteFactory $requestQuoteFactory */
$requestQuoteFactory = $objectManager->get(RequestQuoteFactory::class);

/** @var QuoteResource $quoteResource */
$quoteResource = $objectManager->get(QuoteResource::class);

/** @var RequestQuoteResource $requestQuoteResource */
$requestQuoteResource = $objectManager->get(RequestQuoteResource::class);

/** @var QuoteManagementInterface $quoteManagement */
$quoteManagement = $objectManager->create(QuoteManagementInterface::class);

/** @var CustomerRepositoryInterface $customerRepository */
$customerRepository = $objectManager->create(CustomerRepositoryInterface::class);

$customerId = $customerRepository->get('customer_quote@example.com')->getId();

$requestQuote = $requestQuoteFactory->create();
$requestQuoteResource->load($requestQuote, 'test_order_active', 'reserved_order_id');

$cartQuote = $quoteFactory->create();
$quoteResource->load($cartQuote, 'test_quote', 'reserved_order_id');

$quoteManagement->moveInCart((int)$requestQuote->getId(), (int)$cartQuote->getId(), (int)$customerId);
