<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Request a Quote GraphQl for Magento 2 (System)
 */

use Amasty\RequestQuote\Api\QuoteManagementInterface;
use Magento\Customer\Api\CustomerRepositoryInterface;
use Magento\Framework\Api\SearchCriteriaBuilder;
use Magento\TestFramework\Helper\Bootstrap;
use Amasty\RequestQuote\Api\QuoteRepositoryInterface;

$objectManager = Bootstrap::getObjectManager();

/** @var QuoteRepositoryInterface $quoteRepository */
$quoteRepository = $objectManager->create(QuoteRepositoryInterface::class);

/** @var QuoteManagementInterface $quoteManagement */
$quoteManagement = $objectManager->create(QuoteManagementInterface::class);

/** @var SearchCriteriaBuilder $searchCriteriaBuilder */
$searchCriteriaBuilder = $objectManager->create(SearchCriteriaBuilder::class);

/** @var CustomerRepositoryInterface $customerRepository **/
$customerRepository = $objectManager->create(CustomerRepositoryInterface::class);

$searchCriteria = $searchCriteriaBuilder
    ->addFilter('reserved_order_id', 'test_order_active')
    ->create();

$customer = $customerRepository->get('customer_quote@example.com');
$customerId = $customer->getId();

$quotes = $quoteRepository->getRequestsList($searchCriteria)->getItems();

foreach ($quotes as $quote) {
    $quoteManagement->assignCustomer((int)$quote->getId(), (int)$customerId, 1);
}
