<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Request a Quote GraphQl for Magento 2 (System)
 */

use Amasty\RequestQuote\Model\Source\Status;
use Magento\TestFramework\Helper\Bootstrap;
use Amasty\RequestQuote\Api\QuoteRepositoryInterface;
use Amasty\RequestQuote\Model\QuoteFactory;
use Amasty\RequestQuote\Model\ResourceModel\Quote as QuoteResource;

$objectManager = Bootstrap::getObjectManager();

/** @var QuoteRepositoryInterface $quoteRepository */
$quoteRepository = $objectManager->create(QuoteRepositoryInterface::class);

/** @var QuoteFactory $quoteFactory */
$quoteFactory = $objectManager->get(QuoteFactory::class);

/** @var QuoteResource $quoteResource */
$quoteResource = $objectManager->get(QuoteResource::class);

$quote = $quoteFactory->create();
$quoteResource->load($quote, 'test_order_active', 'reserved_order_id');

$submitQuote = $quoteRepository->get($quote->getId());
$submitQuote->setStatus(Status::APPROVED);
$quoteRepository->save($submitQuote);
