<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Request a Quote GraphQl for Magento 2 (System)
 */

use Magento\Catalog\Api\ProductRepositoryInterface;
use Magento\Quote\Api\CartRepositoryInterface;
use Magento\Quote\Model\QuoteFactory;
use Magento\Quote\Model\ResourceModel\Quote as QuoteResource;
use Magento\TestFramework\Helper\Bootstrap;
use Magento\TestFramework\Workaround\Override\Fixture\Resolver;

Resolver::getInstance()->requireDataFixture('Magento/Multishipping/Fixtures/simple_product_10.php');
Resolver::getInstance()->requireDataFixture('Magento/Multishipping/Fixtures/simple_product_20.php');

$objectManager = Bootstrap::getObjectManager();

/** @var ProductRepositoryInterface $productRepository */
$productRepository = $objectManager->get(ProductRepositoryInterface::class);

/** @var QuoteFactory $quoteFactory */
$quoteFactory = $objectManager->get(QuoteFactory::class);

/** @var QuoteResource $quoteResource */
$quoteResource = $objectManager->get(QuoteResource::class);

/** @var CartRepositoryInterface $cartRepository */
$cartRepository = $objectManager->get(CartRepositoryInterface::class);

$productFirst = $productRepository->get('simple_10');
$productSecond = $productRepository->get('simple_20');

$quote = $quoteFactory->create();
$quoteResource->load($quote, 'test_order_active', 'reserved_order_id');
$quote->addProduct($productFirst, 2);
$quote->addProduct($productSecond, 3);
$quote->collectTotals();

$cartRepository->save($quote);
