<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Request a Quote GraphQl for Magento 2 (System)
 */

use Amasty\RequestQuote\Api\QuoteManagementInterface;
use Magento\Framework\Api\SearchCriteriaBuilder;
use Magento\TestFramework\Helper\Bootstrap;
use Amasty\RequestQuote\Api\QuoteRepositoryInterface;

$objectManager = Bootstrap::getObjectManager();

/** @var QuoteRepositoryInterface $quoteRepository */
$quoteRepository = $objectManager->create(QuoteRepositoryInterface::class);

/** @var QuoteManagementInterface $quoteManagement */
$quoteManagement = $objectManager->create(QuoteManagementInterface::class);

/** @var SearchCriteriaBuilder $searchCriteriaBuilder */
$searchCriteriaBuilder = $objectManager->create(SearchCriteriaBuilder::class);
$searchCriteria = $searchCriteriaBuilder
    ->addFilter('reserved_order_id', 'test_order_active')
    ->create();

$quotes = $quoteRepository->getRequestsList($searchCriteria)->getItems();

foreach ($quotes as $quote) {
    $quoteManagement->updateCustomerNote($quote->getId(), 'Test graph customer note');
}
