<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Request a Quote GraphQl for Magento 2 (System)
 */

use Amasty\RequestQuote\Api\Data\QuoteInterface;
use Magento\Quote\Model\QuoteIdMask;
use Magento\Quote\Model\QuoteIdMaskFactory;
use Magento\Store\Model\StoreManagerInterface;
use Magento\TestFramework\Helper\Bootstrap;
use Amasty\RequestQuote\Api\QuoteRepositoryInterface;

$objectManager = Bootstrap::getObjectManager();

/** @var QuoteRepositoryInterface $quoteRepository */
$quoteRepository = $objectManager->create(QuoteRepositoryInterface::class);

/** @var QuoteInterface $quote */
$quote = $objectManager->create(QuoteInterface::class);

/** @var StoreManagerInterface $storeManager */
$storeManager = $objectManager->create(StoreManagerInterface::class);

$quote->setStoreId(1)
    ->setIsActive(true)
    ->setReservedOrderId('test_order_active')
    ->setQuoteCurrencyCode($storeManager->getStore(1)->getCurrentCurrencyCode());
$quoteRepository->save($quote);

/** @var QuoteIdMask $quoteIdMask */
$quoteIdMask = Bootstrap::getObjectManager()->create(QuoteIdMaskFactory::class)->create();
$quoteIdMask->setQuoteId($quote->getId());
$quoteIdMask->setDataChanges(true);
$quoteIdMask->save();
