<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Request a Quote GraphQl for Magento 2 (System)
 */

namespace Amasty\RequestAQuoteGraphql\Test\GraphQl;

use Magento\GraphQl\Quote\GetMaskedQuoteIdByReservedOrderId;
use Magento\GraphQl\Quote\GetQuoteItemIdByReservedQuoteIdAndSku;
use Magento\TestFramework\Helper\Bootstrap;
use Magento\TestFramework\TestCase\GraphQlAbstract;

class RemoveItemFromQuoteCartTest extends GraphQlAbstract
{
    public const MAIN_QUERY_KEY = 'removeItemFromQuoteCart';

    /**
     * @var GetMaskedQuoteIdByReservedOrderId
     */
    private $getMaskedQuoteIdByReservedOrderId;

    /**
     * @var GetQuoteItemIdByReservedQuoteIdAndSku
     */
    private $getQuoteItemIdByReservedQuoteIdAndSku;

    protected function setUp(): void
    {
        $objectManager = Bootstrap::getObjectManager();
        $this->getMaskedQuoteIdByReservedOrderId = $objectManager->get(GetMaskedQuoteIdByReservedOrderId::class);
        $this->getQuoteItemIdByReservedQuoteIdAndSku = $objectManager->get(
            GetQuoteItemIdByReservedQuoteIdAndSku::class
        );
    }

    /**
     * @group amasty_request_a_quote
     *
     * @magentoApiDataFixture Amasty_RequestAQuoteGraphql::Test/GraphQl/_files/enable_module.php
     * @magentoApiDataFixture Amasty_RequestAQuoteGraphql::Test/GraphQl/_files/set_allowed_groups.php
     *
     * @magentoApiDataFixture Amasty_RequestAQuoteGraphql::Test/GraphQl/_files/active_quote/active_quote.php
     * @magentoApiDataFixture Amasty_RequestAQuoteGraphql::Test/GraphQl/_files/active_quote/add_two_products_to_cart.php
     */
    public function testRemoveItemFromQuoteCart(): void
    {
        $maskedQuoteId = $this->getMaskedQuoteIdByReservedOrderId->execute('test_order_active');
        $cartItemId = $this->getQuoteItemIdByReservedQuoteIdAndSku->execute('test_order_active', 'simple_10');

        $fields = [
            'cart' => [
                'amastyQuote' => [
                    'status' => 0
                ],
                'items' => [
                    [
                        'product' => [
                            'sku' => 'simple_20'
                        ],
                        'quantity' => 3
                    ]
                ]
            ]
        ];

        $query = $this->getQuery($maskedQuoteId, $cartItemId);
        $response = $this->graphQlMutation($query);

        $this->assertArrayHasKey(self::MAIN_QUERY_KEY, $response);
        $this->assertResponseFields($response[self::MAIN_QUERY_KEY], $fields);
    }

    /**
     * Returns GraphQl query string
     */
    private function getQuery(string $cartId, int $cartItemId): string
    {
        return <<<MUTATION
mutation {
    removeItemFromQuoteCart(
        input: {
            cart_id:"$cartId",
            cart_item_id:"$cartItemId"
        }
    ) {
        cart {
            amastyQuote {
                status
            }
            items {
                product {
                    sku
                }
                quantity
            }
        }
    }
}

MUTATION;
    }
}
