<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Request a Quote GraphQl for Magento 2 (System)
 */

namespace Amasty\RequestAQuoteGraphql\Test\GraphQl;

use Magento\TestFramework\TestCase\GraphQlAbstract;

class IsQuoteCartEnabledTest extends GraphQlAbstract
{
    public const MAIN_QUERY_KEY = 'isQuoteCartEnabled';

    /**
     * @group amasty_request_a_quote
     */
    public function testDisableQuoteCart(): void
    {
        $query = $this->getQuery();
        $response = $this->graphQlQuery($query);

        $this->assertArrayHasKey(self::MAIN_QUERY_KEY, $response);
        self::assertEquals(false, $response[self::MAIN_QUERY_KEY]);
    }

    /**
     * @group amasty_request_a_quote
     *
     * @magentoApiDataFixture Amasty_RequestAQuoteGraphql::Test/GraphQl/_files/enable_module.php
     */
    public function testEnableQuoteCart(): void
    {
        $query = $this->getQuery();
        $response = $this->graphQlQuery($query);

        $this->assertArrayHasKey(self::MAIN_QUERY_KEY, $response);
        self::assertEquals(true, $response[self::MAIN_QUERY_KEY]);
    }

    /**
     * Returns GraphQl query string
     */
    private function getQuery(): string
    {
        return <<<QUERY
query {
    isQuoteCartEnabled
}
QUERY;
    }
}
