<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Request a Quote GraphQl for Magento 2 (System)
 */

namespace Amasty\RequestAQuoteGraphql\Test\GraphQl;

use Amasty\RequestQuote\Api\QuoteRepositoryInterface;
use Magento\Quote\Model\MaskedQuoteIdToQuoteIdInterface;
use Magento\TestFramework\Helper\Bootstrap;
use Magento\TestFramework\TestCase\GraphQlAbstract;

class CreateEmptyQuoteCartTest extends GraphQlAbstract
{
    public const MAIN_QUERY_KEY = 'createEmptyQuoteCart';

    /**
     * @var MaskedQuoteIdToQuoteIdInterface
     */
    private $maskedQuoteIdToQuoteId;

    /**
     * @var QuoteRepositoryInterface
     */
    private $quoteRepository;

    protected function setUp(): void
    {
        $objectManager = Bootstrap::getObjectManager();
        $this->maskedQuoteIdToQuoteId = $objectManager->get(MaskedQuoteIdToQuoteIdInterface::class);
        $this->quoteRepository = $objectManager->get(QuoteRepositoryInterface::class);
    }

    /**
     * @group amasty_request_a_quote
     *
     * @magentoApiDataFixture Amasty_RequestAQuoteGraphql::Test/GraphQl/_files/enable_module.php
     * @magentoApiDataFixture Amasty_RequestAQuoteGraphql::Test/GraphQl/_files/set_allowed_groups.php
     */
    public function testGetQuoteCart(): void
    {
        $quoteMaskId = 'testWdqweGraph' . rand(1000, 9999) . 'EqawQuote' . rand(10000, 99999);

        $query = $this->getQuery($quoteMaskId);
        $response = $this->graphQlMutation($query);

        $this->assertArrayHasKey(self::MAIN_QUERY_KEY, $response);
        $this->assertEquals($quoteMaskId, $response[self::MAIN_QUERY_KEY]);

        // assert returned quoteId by mask
        $this->assertIsInt($this->maskedQuoteIdToQuoteId->execute($quoteMaskId));

        $quote = $this->quoteRepository->get($this->maskedQuoteIdToQuoteId->execute($quoteMaskId));
        $this->quoteRepository->delete($quote);
    }

    /**
     * Returns GraphQl query string
     */
    private function getQuery(string $quoteMaskId): string
    {
        return <<<MUTATION
mutation {
  createEmptyQuoteCart(input: {
    quote_mask_id: $quoteMaskId
  })
}
MUTATION;
    }
}
