<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Request a Quote GraphQl for Magento 2 (System)
 */

namespace Amasty\RequestAQuoteGraphql\Plugin\QuoteGraphQl\Model\Resolver\ShippingAddress\AvailableShippingMethods;

use Amasty\RequestQuote\Api\Data\QuoteInterface;
use Amasty\RequestQuote\Model\Quote\Frontend\GetAmastyQuote;
use Magento\Framework\GraphQl\Config\Element\Field;
use Magento\Framework\GraphQl\Schema\Type\ResolveInfo;
use Magento\Quote\Model\Quote\Address;
use Magento\QuoteGraphQl\Model\Resolver\ShippingAddress\AvailableShippingMethods;

class RestrictMethods
{
    /**
     * @var GetAmastyQuote
     */
    private $getAmastyQuote;

    public function __construct(GetAmastyQuote $getAmastyQuote)
    {
        $this->getAmastyQuote = $getAmastyQuote;
    }

    /**
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function afterResolve(
        AvailableShippingMethods $subject,
        array $methods,
        Field $field,
        $context,
        ResolveInfo $info,
        array $value = null,
        array $args = null
    ): array {
        /** @var Address $address */
        $address = clone $value['model'];

        $address->getShippingRatesCollection();
        $amastyQuote = $this->getAmastyQuote->execute($address->getQuote());
        if ($amastyQuote
            && $amastyQuote->isShippingConfigure()
            && !$amastyQuote->getData(QuoteInterface::SHIPPING_CAN_BE_MODIFIED)
        ) {
            $methods = array_filter($methods, function (array $method) use ($address) {
                return $method['carrier_code'] . '_' . $method['method_code'] === $address->getShippingMethod();
            });
        }

        return $methods;
    }
}
