<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Request a Quote GraphQl for Magento 2 (System)
 */

namespace Amasty\RequestAQuoteGraphql\Plugin\QuoteGraphQl\Model\Cart\SetShippingAddressesOnCartInterface;

use Amasty\RequestQuote\Api\Data\QuoteInterface;
use Amasty\RequestQuote\Model\Quote\Frontend\GetAmastyQuote;
use Magento\GraphQl\Model\Query\ContextInterface;
use Magento\Quote\Api\Data\CartInterface;
use Magento\QuoteGraphQl\Model\Cart\SetShippingAddressesOnCartInterface;

class RestrictChangeAddress
{
    /**
     * @var GetAmastyQuote
     */
    private $getAmastyQuote;

    public function __construct(GetAmastyQuote $getAmastyQuote)
    {
        $this->getAmastyQuote = $getAmastyQuote;
    }

    /**
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function aroundExecute(
        SetShippingAddressesOnCartInterface $subject,
        callable $proceed,
        ContextInterface $context,
        CartInterface $cart,
        array $shippingAddressesInput
    ): void {
        $amastyQuote = $this->getAmastyQuote->execute($cart);
        if ($amastyQuote
            && $amastyQuote->isShippingConfigure()
            && !$amastyQuote->getData(QuoteInterface::SHIPPING_CAN_BE_MODIFIED)
        ) {
            return;
        }

        $proceed($context, $cart, $shippingAddressesInput);
    }
}
