<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Request a Quote GraphQl for Magento 2 (System)
 */

namespace Amasty\RequestAQuoteGraphql\Plugin\QuoteGraphQl\Model\Cart\AssignShippingMethodToCart;

use Amasty\RequestQuote\Api\Data\QuoteInterface;
use Amasty\RequestQuote\Model\Quote\Frontend\GetAmastyQuote;
use Magento\Quote\Api\Data\AddressInterface;
use Magento\Quote\Api\Data\CartInterface;
use Magento\QuoteGraphQl\Model\Cart\AssignShippingMethodToCart;

class RestrictChangeMethod
{
    /**
     * @var GetAmastyQuote
     */
    private $getAmastyQuote;

    public function __construct(GetAmastyQuote $getAmastyQuote)
    {
        $this->getAmastyQuote = $getAmastyQuote;
    }

    /**
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function aroundExecute(
        AssignShippingMethodToCart $subject,
        callable $proceed,
        CartInterface $cart,
        AddressInterface $quoteAddress,
        string $carrierCode,
        string $methodCode
    ): void {
        $amastyQuote = $this->getAmastyQuote->execute($cart);
        if ($amastyQuote
            && $amastyQuote->isShippingConfigure()
            && !$amastyQuote->getData(QuoteInterface::SHIPPING_CAN_BE_MODIFIED)
            && $carrierCode . '_' . $methodCode !== $quoteAddress->getShippingMethod()
        ) {
            return;
        }

        $proceed($cart, $quoteAddress, $carrierCode, $methodCode);
    }
}
