<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Request a Quote GraphQl for Magento 2 (System)
 */

namespace Amasty\RequestAQuoteGraphql\Model\Resolver\UpdateQuoteItems\Input;

use Amasty\RequestAQuoteGraphql\Model\Resolver\UpdateQuoteItems;

class ResolveNestedCartItemsInput
{
    public function execute(array $args): array
    {
        if (isset($args[UpdateQuoteItems::INPUT_CODE][UpdateQuoteItems::CART_ITEMS_CODE])) {
            foreach ($args[UpdateQuoteItems::INPUT_CODE][UpdateQuoteItems::CART_ITEMS_CODE] as &$cartItemData) {
                if (isset($cartItemData[UpdateQuoteItems::CUSTOM_ITEM_INPUT_CODE])) {
                    // phpcs:ignore Magento2.Performance.ForeachArrayMerge.ForeachArrayMerge
                    $cartItemData = array_merge($cartItemData, $cartItemData[UpdateQuoteItems::CUSTOM_ITEM_INPUT_CODE]);
                    unset($cartItemData[UpdateQuoteItems::CUSTOM_ITEM_INPUT_CODE]);
                }
            }
        }

        return $args;
    }
}
