<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Request a Quote GraphQl for Magento 2 (System)
 */

namespace Amasty\RequestAQuoteGraphql\Model\Resolver\UpdateQuoteItems\Input;

use Amasty\RequestAQuoteGraphql\Model\Resolver\UpdateQuoteItems;

class PrepareAssociativeItems
{
    /**
     * Prepare array for \Amasty\RequestQuote\Model\Quote\Frontend\UpdateQuoteItems
     *
     * @return array [item_id => data, ...]
     */
    public function execute(array $processedArgs): array
    {
        $cartItemsData = $processedArgs[UpdateQuoteItems::INPUT_CODE][UpdateQuoteItems::CART_ITEMS_CODE] ?? [];
        $newCartItemsData = [];
        foreach ($cartItemsData as $cartItemData) {
            $newCartItemsData[$cartItemData[UpdateQuoteItems::CART_ITEM_ID_CODE]] = $cartItemData;
        }
        $processedArgs[UpdateQuoteItems::INPUT_CODE][UpdateQuoteItems::CART_ITEMS_CODE] = $newCartItemsData;

        return $processedArgs;
    }
}
