<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Request a Quote GraphQl for Magento 2 (System)
 */

namespace Amasty\RequestAQuoteGraphql\Model\Resolver;

use Amasty\RequestAQuoteGraphql\Model\Formatter\Customer\QuoteItem as QuoteItemFormatter;
use Amasty\RequestAQuoteGraphql\Model\QuoteCart\IsEnabled as IsQuoteCartEnabledProvider;
use Amasty\RequestQuote\Api\Data\QuoteInterface;
use Amasty\RequestQuote\Model\Quote;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\GraphQl\Config\Element\Field;
use Magento\Framework\GraphQl\Exception\GraphQlAuthorizationException;
use Magento\Framework\GraphQl\Query\ResolverInterface;
use Magento\Framework\GraphQl\Schema\Type\ResolveInfo;
use Magento\GraphQl\Model\Query\Context;

class CustomerQuoteItems implements ResolverInterface
{
    /**
     * @var IsQuoteCartEnabledProvider
     */
    private $isQuoteCartEnabled;

    /**
     * @var QuoteItemFormatter
     */
    private $quoteItemFormatter;

    public function __construct(
        IsQuoteCartEnabledProvider $isQuoteCartEnabled,
        QuoteItemFormatter $quoteItemFormatter
    ) {
        $this->isQuoteCartEnabled = $isQuoteCartEnabled;
        $this->quoteItemFormatter = $quoteItemFormatter;
    }

    /**
     * @param Field $field
     * @param Context $context
     * @param ResolveInfo $info
     * @param array|null $value
     * @param array|null $args
     * @return array
     * @throws LocalizedException
     *
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function resolve(Field $field, $context, ResolveInfo $info, array $value = null, array $args = null)
    {
        if (!$this->isQuoteCartEnabled->execute()) {
            throw new GraphQlAuthorizationException(__('Quote Cart has been disabled.'));
        }

        if (!isset($value['model'])) {
            throw new LocalizedException(__('"model" value should be specified'));
        }

        /** @var QuoteInterface|Quote $quote */
        $quote = $value['model'];

        $quoteItemsArray = [];
        foreach ($quote->getAllVisibleItems() as $quoteItem) {
            $quoteItemsArray[] = $this->quoteItemFormatter->format($quoteItem);
        }

        return $quoteItemsArray;
    }
}
