<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Request a Quote GraphQl for Magento 2 (System)
 */

namespace Amasty\RequestAQuoteGraphql\Model\QuoteCart\SubmitQuote;

use Magento\Customer\Api\Data\CustomerInterface;

class CustomerToken
{
    /**
     * @var CustomerInterface
     */
    private $customer;

    /**
     * @var string
     */
    private $token;

    public function __construct(CustomerInterface $customer, string $token)
    {
        $this->customer = $customer;
        $this->token = $token;
    }

    public function getCustomer(): CustomerInterface
    {
        return $this->customer;
    }

    public function getToken(): string
    {
        return $this->token;
    }
}
