<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Request a Quote GraphQl for Magento 2 (System)
 */

namespace Amasty\RequestAQuoteGraphql\Model\QuoteCart;

use Amasty\RequestQuote\Model\ConfigProvider;

class IsEnabledForCustomer
{
    /**
     * @var ConfigProvider
     */
    private $configProvider;

    /**
     * @var IsEnabled
     */
    private $isEnabled;

    public function __construct(ConfigProvider $configProvider, IsEnabled $isEnabled)
    {
        $this->configProvider = $configProvider;
        $this->isEnabled = $isEnabled;
    }

    public function execute(?int $customerGroupId): bool
    {
        return $customerGroupId !== null
            && $this->isEnabled->execute()
            && in_array($customerGroupId, $this->configProvider->getAllowedCustomerGroups());
    }
}
