<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Request a Quote GraphQl for Magento 2 (System)
 */

namespace Amasty\RequestAQuoteGraphql\Model\QuoteCart;

use Amasty\RequestAQuoteGraphql\Model\QuoteManagement;
use Magento\Quote\Model\QuoteIdMaskFactory;
use Magento\Quote\Model\ResourceModel\Quote\QuoteIdMask as QuoteIdMaskResourceModel;

class CreateEmptyQuoteCartForGuest
{
    /**
     * @var QuoteIdMaskFactory
     */
    private $quoteIdMaskFactory;

    /**
     * @var QuoteIdMaskResourceModel
     */
    private $quoteIdMaskResourceModel;

    /**
     * @var QuoteManagement
     */
    private $quoteManagement;

    public function __construct(
        QuoteIdMaskFactory $quoteIdMaskFactory,
        QuoteIdMaskResourceModel $quoteIdMaskResourceModel,
        QuoteManagement $quoteManagement
    ) {
        $this->quoteIdMaskFactory = $quoteIdMaskFactory;
        $this->quoteIdMaskResourceModel = $quoteIdMaskResourceModel;
        $this->quoteManagement = $quoteManagement;
    }

    public function execute(string $predefinedMaskedQuoteId = null): string
    {
        $maskedQuoteId = $this->createEmptyQuote();

        if (isset($predefinedMaskedQuoteId)) {
            $quoteIdMask = $this->quoteIdMaskFactory->create();
            $this->quoteIdMaskResourceModel->load($quoteIdMask, $maskedQuoteId, 'masked_id');
            $quoteIdMask->setMaskedId($predefinedMaskedQuoteId);
            $this->quoteIdMaskResourceModel->save($quoteIdMask);
        }

        return $predefinedMaskedQuoteId ?? $maskedQuoteId;
    }

    private function createEmptyQuote(): string
    {
        $quoteIdMask = $this->quoteIdMaskFactory->create();
        $quoteId = $this->quoteManagement->createEmptyQuote();
        $quoteIdMask->setQuoteId($quoteId)->save();

        return $quoteIdMask->getMaskedId();
    }
}
