<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Request a Quote GraphQl for Magento 2 (System)
 */

namespace Amasty\RequestAQuoteGraphql\Model\QuoteCart;

use Magento\Quote\Model\QuoteIdToMaskedQuoteIdInterface;

class CreateEmptyQuoteCartForCustomer
{
    /**
     * @var QuoteIdToMaskedQuoteIdInterface
     */
    private $quoteIdToMaskedQuoteId;

    /**
     * @var CustomerQuoteResolver
     */
    private $customerQuoteResolver;

    public function __construct(
        QuoteIdToMaskedQuoteIdInterface $quoteIdToMaskedQuoteId,
        CustomerQuoteResolver $customerQuoteResolver
    ) {
        $this->quoteIdToMaskedQuoteId = $quoteIdToMaskedQuoteId;
        $this->customerQuoteResolver = $customerQuoteResolver;
    }

    public function execute(int $customerId, string $predefinedMaskedQuoteId = null): string
    {
        $quote = $this->customerQuoteResolver->resolve($customerId, $predefinedMaskedQuoteId);
        $quoteId = (int)$quote->getId();

        return $this->quoteIdToMaskedQuoteId->execute($quoteId);
    }
}
