<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Request a Quote GraphQl for Magento 2 (System)
 */

namespace Amasty\RequestAQuoteGraphql\Model\Formatter\Customer;

use Amasty\Base\Model\Serializer;
use Amasty\RequestQuote\Api\Data\QuoteInterface;

class Quote
{
    /**
     * @var Serializer
     */
    private $serializer;

    public function __construct(Serializer $serializer)
    {
        $this->serializer = $serializer;
    }

    public function format(QuoteInterface $quote): array
    {
        $remarks = $this->serializer->unserialize($quote->getRemarks());

        return [
            'model' => $quote,
            'id' => base64_encode($quote->getEntityId()),
            'number' => $quote->getIncrementId(),
            'status' => $quote->getStatusLabel(),
            'quote_date' => $quote->getCreatedAt(),
            'notes' => [
                'customer_note' => $remarks[QuoteInterface::CUSTOMER_NOTE_KEY] ?? '',
                'admin_note' => $remarks[QuoteInterface::ADMIN_NOTE_KEY] ?? ''
            ]
        ];
    }
}
