<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Advanced Reports Convert To Report Builder for Magento 2
*/

declare(strict_types=1);

namespace Amasty\ReportsToBuilder\Model\ReportResolver;

use Amasty\ReportBuilder\Api\ColumnInterface;
use Amasty\ReportBuilder\Api\Data\ReportColumnInterface;
use Magento\Framework\App\Config\ScopeConfigInterface;

/**
 * Retrieve column name from system configuration by path.
 */
class SystemConfigColumn
{
    public const PATH_KEY = 'config_path';

    /**
     * @var ScopeConfigInterface
     */
    private $scopeConfig;

    public function __construct(ScopeConfigInterface $scopeConfig)
    {
        $this->scopeConfig = $scopeConfig;
    }

    public function collectColumnId(array &$column): void
    {
        $columnName = (string) $this->scopeConfig->getValue($column[self::PATH_KEY]);
        
        $column[ReportColumnInterface::COLUMN_ID] = $column[ColumnInterface::ENTITY_NAME] . '.' . $columnName;
        unset($column[self::PATH_KEY]);
    }
}
