<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Advanced Reports Convert To Report Builder for Magento 2
*/

declare(strict_types=1);

namespace Amasty\ReportsToBuilder\Model\ReportResolver;

use Amasty\ReportBuilder\Model\Report\ColumnFactory;
use Amasty\ReportBuilder\Model\Report\ColumnRegistry;

class RegisterColumn
{
    public const NEW_REPORT_ID = 0;

    /**
     * @var ColumnRegistry
     */
    private $columnRegistry;

    /**
     * @var ColumnFactory
     */
    private $columnModelFactory;

    public function __construct(
        ColumnRegistry $columnRegistry,
        ColumnFactory $columnModelFactory
    ) {
        $this->columnRegistry = $columnRegistry;
        $this->columnModelFactory = $columnModelFactory;
    }

    /**
     * Transform column data to Object and set it to the registry.
     *
     * @param array $columnData
     * @return void
     */
    public function register(array $columnData): void
    {
        $columnModel = $this->columnModelFactory->create();
        $columnModel->addData($columnData);
        $this->columnRegistry->addItem(self::NEW_REPORT_ID, $columnModel);
    }
}
