<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Advanced Reports Convert To Report Builder for Magento 2
*/

declare(strict_types=1);

namespace Amasty\ReportsToBuilder\Model;

use Amasty\Base\Model\Serializer;
use Magento\Framework\Filesystem\Directory\ReadFactory;
use Magento\Framework\Filesystem\Directory\ReadInterface;
use Magento\Framework\Module\Dir;

class ReportDataRepository
{
    public const MODULE_NAME = 'Amasty_ReportsToBuilder';

    /**
     * @var ReadInterface|null
     */
    private $resource;

    /**
     * @var Dir
     */
    private $moduleDirs;

    /**
     * @var ReadFactory
     */
    private $readFactory;

    /**
     * @var Serializer
     */
    private $serializer;

    public function __construct(
        Dir $moduleDirs,
        ReadFactory $readFactory,
        Serializer $serializer
    ) {
        $this->moduleDirs = $moduleDirs;
        $this->readFactory = $readFactory;
        $this->serializer = $serializer;
    }

    private function getResource(): ReadInterface
    {
        if ($this->resource === null) {
            $filesDirectory = $this->moduleDirs->getDir(self::MODULE_NAME) . '/fixture';

            $this->resource = $this->readFactory->create($filesDirectory);
        }

        return $this->resource;
    }

    /**
     * @param string $handleId
     *
     * @return bool
     */
    public function isExist(string $handleId): bool
    {
        return $this->getResource()->isExist($this->getFileName($handleId));
    }

    /**
     * @param string $handleId
     *
     * @return array
     */
    public function get(string $handleId): array
    {
        return $this->serializer->unserialize($this->getResource()->readFile($this->getFileName($handleId)));
    }

    /**
     * @param string $handleId
     *
     * @return string
     */
    private function getFileName(string $handleId): string
    {
        return $handleId . '.json';
    }
}
