<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Advanced Reports Convert To Report Builder for Magento 2
*/

declare(strict_types=1);

namespace Amasty\ReportsToBuilder\Model;

use Magento\Framework\View\Element\Block\ArgumentInterface;

/**
 * Is allowed to migrate specific Advanced Report to Custom Report Builder
 */
class IsMigrationAllowed implements ArgumentInterface
{
    /**
     * @var ReportDataRepository
     */
    private $dataRepository;

    public function __construct(ReportDataRepository $dataRepository)
    {
        $this->dataRepository = $dataRepository;
    }

    public function byHandle(string $handleId): bool
    {
        return $this->dataRepository->isExist($handleId);
    }
}
