<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Advanced Reports Convert To Report Builder for Magento 2
*/

declare(strict_types=1);

namespace Amasty\ReportsToBuilder\Controller\Adminhtml\ToBuilder;

use Amasty\ReportBuilder\Controller\Adminhtml\Report\NewAction as ReportBuilderNewAction;
use Amasty\ReportBuilder\Model\ReportRegistry;
use Amasty\ReportsToBuilder\Model\IsMigrationAllowed;
use Amasty\ReportsToBuilder\Model\ReportResolver;
use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Framework\App\Action\HttpGetActionInterface;
use Magento\Framework\Controller\ResultFactory;

class FromAdvanced extends Action implements HttpGetActionInterface
{
    public const HANDLE_PARAM = 'handle';

    /**
     * @var IsMigrationAllowed
     */
    private $migrationAllowed;

    /**
     * @var ReportRegistry
     */
    private $registry;

    /**
     * @var ReportResolver
     */
    private $reportResolver;

    public function __construct(
        Context $context,
        IsMigrationAllowed $migrationAllowed,
        ReportRegistry $registry,
        ReportResolver $reportResolver
    ) {
        parent::__construct($context);
        $this->migrationAllowed = $migrationAllowed;
        $this->registry = $registry;
        $this->reportResolver = $reportResolver;
    }

    public function execute()
    {
        $report = $this->reportResolver->getReportByHandle($this->getHandle());
        $this->registry->setReport($report);

        $params = $this->getRequest()->getParams();
        $params['report_id'] = $report->getReportId();
        $this->getRequest()->setParams($params);

        $resultPage = $this->resultFactory->create(ResultFactory::TYPE_PAGE);
        $resultPage->addHandle('amreportbuilder_report_edit');

        $resultPage->setActiveMenu('Amasty_ReportBuilder::Amasty_ReportBuilder');
        $resultPage->getConfig()->getTitle()->prepend(__('Amasty Custom Reports Builder'));

        return $resultPage;
    }

    protected function _isAllowed()
    {
        return $this->_authorization->isAllowed(ReportBuilderNewAction::ADMIN_RESOURCE)
            && $this->migrationAllowed->byHandle($this->getHandle());
    }

    /**
     * @return string
     */
    private function getHandle(): string
    {
        return $this->getRequest()->getParam(self::HANDLE_PARAM, '');
    }
}
