<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Advanced Reports Convert To Report Builder for Magento 2
*/

declare(strict_types=1);

namespace Amasty\ReportsToBuilder\Block;

use Amasty\ReportBuilder\Controller\Adminhtml\Report\NewAction as ReportBuilderNewAction;
use Amasty\ReportsToBuilder\Controller\Adminhtml\ToBuilder\FromAdvanced;
use Amasty\ReportsToBuilder\Model\IsMigrationAllowed;
use Magento\Backend\Block\Widget\Button;

class MigrateButton extends Button
{
    /**
     * @return string
     */
    public function getHandle(): string
    {
        if ($this->hasData('handle')) {
            return $this->getDataByKey('handle');
        }

        return $this->getRequest()->getFullActionName();
    }

    /**
     * @return IsMigrationAllowed
     */
    public function getIsAllowedResolver(): IsMigrationAllowed
    {
        return $this->getDataByKey('is_allowed_resolver');
    }

    /**
     * @return bool
     */
    public function isAllowed(): bool
    {
        $allowedResolver = $this->getIsAllowedResolver();

        return $this->_authorization->isAllowed(ReportBuilderNewAction::ADMIN_RESOURCE)
            && $allowedResolver->byHandle($this->getHandle());
    }

    /**
     * @return string
     */
    public function getActionUrl(): string
    {
        return $this->getUrl(
            'amMigrateReport/toBuilder/fromAdvanced',
            [FromAdvanced::HANDLE_PARAM => $this->getHandle()]
        );
    }

    /**
     * @return string
     */
    public function getOnClick(): string
    {
        return sprintf('setLocation("%s")', $this->getActionUrl());
    }

    protected function _toHtml()
    {
        if ($this->isAllowed()) {
            return parent::_toHtml();
        }

        return '';
    }
}
