/**
 * Chosen options wrapper component mixin
 */

define([
    'jquery',
    'uiComponent',
    'ko',
    'underscore',
    'amrepbuilder_helpers',
    'amrbvirtual_element_factory'
], function ($, Component, ko, _, helpers, elementFactory) {
    'use strict';

    var mixin = {
        defaults: {
            extendComponents: [
                'index = component_virtual_column'
            ],
            imports: {
                virtualColumn: 'index = component_virtual_column:virtualColumn'
            }
        },
        constants: {
            operandTypes: elementFactory.operandTypes,
            columnTypes: elementFactory.columnTypes
        },

        /**
         * Drag and Drop receive callback
         *
         * @param {Object} event Jquery.event
         * @param {Object} ui
         * @returns {void}
         */
        receiveCallbackDnD: function (event, ui) {
            var self = this,
                prototype = $(ui.item).data('item'),
                virtualColumn = _.clone(self.virtualColumn);

            if (self.isTypeVirtual(prototype)) {
                self.virtualColumnComponent.initVirtualColumn(virtualColumn);
            }

            self.addColumn(
                self.isTypeVirtual(prototype) ? virtualColumn : prototype,
                self.currentDropItem.index()
            );
            self.currentDropItem.remove();
        },

        /**
         * Generate a 'uniq' id string
         *
         * @return {String}
         */
        generateId: function () {
            return helpers.getRandomString();
        },

        /**
         * Check if column is virtual type
         *
         * @param {Object} column
         * @return {Boolean}
         */
        isTypeVirtual: function (column) {
            return _.isUndefined(column.type) || column.type === this.virtualColumn.type;
        },

        /**
         * Initialize particular column
         *
         * @param {Object} column target column
         * @returns {void}
         */
        initColumn: function (column) {
            this._super();

            this.toolbar.initConstructor(column);
        }
    };

    return function (target) {
        return target.extend(mixin);
    };
});
