/**
 * Available options wrapper component mixin
 */

define([], function () {
    'use strict';

    var mixin = {
        /**
         * @inheritDoc
         */
        initObservable: function () {
            this._super()
                .observe({
                    addingColumn: true
                });

            return this;
        },

        /**
         * Prevent adding column when the constructor of some virtual column is open
         *
         * @inheritDoc
         */
        chooseColumn: function (prototype) {
            if (!this.addingColumn()) {
                return;
            }

            this._super(prototype);
        }
    };

    return function (target) {
        return target.extend(mixin);
    };
});
