/**
 * Available Virtual column wrapper
 */

define([
    'jquery',
    'underscore',
    'ko',
    'uiComponent',
    'amrepbuilder_helpers',
    'uiRegistry',
    'mage/translate'
], function ($, _, ko, Component, helpers, registry, $t) {
    'use strict';

    return Component.extend({
        defaults: {
            template: 'Amasty_ReportBuilderVirtual/builder/available_options/virtual/wrapper',
            columnHeaderTmpl: 'Amasty_ReportBuilderVirtual/builder/available_options/virtual/columns/header',
            columnTmpl: 'Amasty_ReportBuilderVirtual/builder/available_options/virtual/columns/column',
            components: [
                'index = entities_list',
                'index = chosen_options'
            ],
            links: {
                addingColumn: 'index = entities_list:addingColumn'
            },
            virtualColumn: {
                title: $t('Custom column'),
                name: 'virtual_column',
                type: 'virtual',
                type_title: 'custom',
                frontend_model: 'text',
                index: 0,
                aggregation: {},
                searchCount: 0,
                isVisible: true,
                isDisabled: false,
                entity_index: 0,
                use_for_period: null,
                filtration: {
                    isActive: false,
                    value: ''
                }
            }
        },

        /**
         * Invokes initialize method of parent class,
         * contains initialization logic
         * @returns {void}
         */
        initialize: function () {
            var self = this;

            self._super();

            registry.get(self.components, function () {
                helpers.initComponentsArray(arguments, self);
            });
        },

        /**
         * Init observable variables
         *
         * @returns {Object}
         */
        initObservable: function () {
            this._super()
                .observe('addingColumn');

            return this;
        },

        /**
         *  Choose and add target column to chosen list via Chosen Component Method
         *
         *  @returns {void}
         */
        chooseColumn: function () {
            var element;

            if (!this.addingColumn()) {
                return;
            }

            element = _.clone(this.virtualColumn);

            this.initVirtualColumn(element);
            this.chosenOptions.addColumn(element);
        },

        /**
         * Initialize virtual column
         *
         * @param {Object} column target column
         * @returns {void}
         */
        initVirtualColumn: function (column) {
            column.title = ko.observable(column.title);
            column.searchCount = ko.observable(0);
            column.isVisible = ko.observable(true);
            column.id = this.chosenOptions.generateId();
            column.index = this.chosenOptions.elems().length;

            if (!column.isDisabled) {
                column.isDisabled = ko.observable(false);
            }
        }
    });
});
