<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Report Builder Virtual Columns (System)
*/

declare(strict_types=1);

namespace Amasty\ReportBuilderVirtual\Ui\DataProvider\Form\Report\Modifier;

use Amasty\ReportBuilderVirtual\Model\Operator\Category\CategoryDataProvider;
use Amasty\ReportBuilderVirtual\Model\Operator\OperatorDataProvider;
use Magento\Ui\DataProvider\Modifier\ModifierInterface;

class Operators implements ModifierInterface
{
    /**
     * @var CategoryDataProvider
     */
    private $categoryDataProvider;

    /**
     * @var OperatorDataProvider
     */
    private $operatorDataProvider;

    public function __construct(
        CategoryDataProvider $categoryDataProvider,
        OperatorDataProvider $operatorDataProvider
    ) {
        $this->categoryDataProvider = $categoryDataProvider;
        $this->operatorDataProvider = $operatorDataProvider;
    }

    public function modifyData(array $data)
    {
        return $data;
    }

    public function modifyMeta(array $meta)
    {
        $meta['amasty_report_builder']['children']['operators_popup']['arguments']['data']['config']['categories'] =
            $this->categoryDataProvider->getData();
        $meta['amasty_report_builder']['children']['operators_popup']['arguments']['data']['config']['operators'] =
            $this->operatorDataProvider->getOperatorsConfigs();

        return $meta;
    }
}
