<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Report Builder Virtual Columns (System)
*/

declare(strict_types=1);

namespace Amasty\ReportBuilderVirtual\Ui\DataProvider\Form\Report\Modifier\Columns;

use Amasty\ReportBuilder\Api\ColumnInterface;
use Amasty\ReportBuilder\Api\Data\ReportColumnInterface;
use Amasty\ReportBuilder\Ui\DataProvider\Form\Report\Modifier\Columns\ModifierInterface;
use Amasty\ReportBuilderVirtual\Api\Data\ReportVirtualColumnInterface;
use Amasty\ReportBuilderVirtual\Model\Backend\Report\DataCollector\Columns\VirtualColumnContext;
use Amasty\ReportBuilderVirtual\Model\Context\Element\Brackets;
use Amasty\ReportBuilderVirtual\Model\Context\Element\Column;
use Amasty\ReportBuilderVirtual\Model\Context\Element\ElementInterface;

class VirtualColumnModifier implements ModifierInterface
{
    public const VIRTUAL_TYPE = 'virtual';

    public function convert(ReportColumnInterface $reportColumn, array &$columnData): void
    {
        /** @var ReportVirtualColumnInterface $virtualColumn */
        $virtualColumn = $reportColumn->getExtensionAttributes()->getVirtualColumn();
        if (!$virtualColumn) {
            return;
        }

        $context = $virtualColumn->getContext();
        $this->mapContextColumns($context);

        $columnData[ColumnInterface::TYPE] = self::VIRTUAL_TYPE;
        $columnData[VirtualColumnContext::COLUMN_DATA_CONTEXT] = $context;
        $columnData[VirtualColumnContext::COLUMN_DATA_TYPE] = $virtualColumn->getDataType();
    }

    /**
     * TODO refactor mapping CAT-16241
     *
     * @param array $elements
     */
    private function mapContextColumns(array &$elements)
    {
        foreach ($elements as &$element) {
            if (!empty($element[Brackets::ELEMENTS_KEY])) {
                $this->mapContextColumns($element[Brackets::ELEMENTS_KEY]);
            }

            if ($element[ElementInterface::CATEGORY_KEY] === Column::CATEGORY) {
                $element['columnData'] = $element;
                unset(
                    $element['columnData']['modifier'],
                    $element['columnData']['operation'],
                    $element['columnData']['columnData']
                );
            }
        }
    }
}
