<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Report Builder Virtual Columns (System)
*/

declare(strict_types=1);

namespace Amasty\ReportBuilderVirtual\Ui\DataProvider\Form\Report\Modifier;

use Magento\Ui\DataProvider\Modifier\ModifierInterface;

class ColumnType implements ModifierInterface
{
    /**
     * @var \Amasty\ReportBuilder\Model\EntityScheme\Column\ColumnType
     */
    private $columnType;

    public function __construct(
        \Amasty\ReportBuilder\Model\EntityScheme\Column\ColumnType $columnType
    ) {
        $this->columnType = $columnType;
    }

    public function modifyData(array $data)
    {
        return $data;
    }

    public function modifyMeta(array $meta)
    {
        $meta['amasty_report_builder']['children']['component_constructor']['arguments']['data']['config']
        ['columnTypes'] = $this->columnType->get();

        return $meta;
    }
}
