<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Report Builder Virtual Columns (System)
*/

declare(strict_types=1);

namespace Amasty\ReportBuilderVirtual\Ui\Component\Listing\View\Columns\Adapter;

use Amasty\ReportBuilder\Api\Data\ReportColumnInterface;
use Amasty\ReportBuilder\Model\EntityScheme\Column\AggregationType;
use Amasty\ReportBuilder\Ui\Component\Listing\View\Columns\Adapter\AdapterInterface;

class VirtualColumnAdapter implements AdapterInterface
{
    public function modify(ReportColumnInterface $reportColumn, array &$config): void
    {
        $virtualColumn = $reportColumn->getExtensionAttributes()->getVirtualColumn();
        if ($virtualColumn === null) {
            return;
        }

        if (!isset($config['label'])) {
            $config['label'] = (string) __('Custom Column');
        }

        $config['dataType'] = 'text';
        $config['aggregation_type'] = AggregationType::DEFAULT_AGGREGATION_TYPE;
        $config['filter'] = 'text';
    }
}
