<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Report Builder Virtual Columns (System)
*/

declare(strict_types=1);
use Amasty\ReportBuilder\Model\Report\ColumnProvider;
use Amasty\ReportBuilder\Model\ReportRepository;
use Amasty\ReportBuilder\Test\Registry;
use Magento\Framework\Api\DataObjectHelper;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\TestFramework\Helper\Bootstrap;

/** @var ColumnProvider $columnFactory */
$columnProvider = Bootstrap::getObjectManager()->get(ColumnProvider::class);
/** @var ReportRepository $reportRepository */
$reportRepository = Bootstrap::getObjectManager()->get(ReportRepository::class);
/** @var DataObjectHelper $dataObjectHelper */
$dataObjectHelper = Bootstrap::getObjectManager()->get(DataObjectHelper::class);

try {
    $reportId = Registry::$REPORT_ID;
    if ($reportId) {
        $columns = $columnProvider->getColumnsByReportId($reportId);
        if (isset($columns['virtual_1'])) {
            $columns['virtual_1']->delete();
            $columns['virtual_2']->delete();
        }
    }
} catch (NoSuchEntityException $e) {
    // deleted
}
