<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Report Builder Virtual Columns (System)
*/

declare(strict_types=1);

use Amasty\ReportBuilder\Api\Data\ReportColumnInterface;
use Amasty\ReportBuilder\Api\Data\ReportColumnInterfaceFactory;
use Amasty\ReportBuilder\Api\Data\ReportInterfaceFactory;
use Amasty\ReportBuilder\Model\ReportRepository;
use Amasty\ReportBuilder\Test\Registry;
use Amasty\ReportBuilderVirtual\Api\Data\ReportVirtualColumnInterface;
use Amasty\ReportBuilderVirtual\Model\Context\Element\Brackets;
use Amasty\ReportBuilderVirtual\Model\Context\Element\Column;
use Amasty\ReportBuilderVirtual\Model\Context\Element\Input;
use Magento\Framework\Api\DataObjectHelper;
use Magento\TestFramework\Helper\Bootstrap;

/** @var ReportInterfaceFactory $columnFactory */
$columnFactory = Bootstrap::getObjectManager()->get(ReportColumnInterfaceFactory::class);
/** @var ReportRepository $reportRepository */
$reportRepository = Bootstrap::getObjectManager()->get(ReportRepository::class);
/** @var DataObjectHelper $dataObjectHelper */
$dataObjectHelper = Bootstrap::getObjectManager()->get(DataObjectHelper::class);

$reportId = Registry::$REPORT_ID;
$report = $reportRepository->getById($reportId);

$columnsData = [
    [
        ReportColumnInterface::REPORT_ID => $reportId,
        ReportColumnInterface::COLUMN_ID => 'virtual_1',
        ReportColumnInterface::EXTENSION_ATTRIBUTES_KEY => [
            ReportVirtualColumnInterface::EXTENDED_KEY => [
                ReportVirtualColumnInterface::CONTEXT => [
                    [
                        Column::CATEGORY_KEY => Column::CATEGORY,
                        Column::COLUMN_ID => 'order_item.price',
                        Column::TYPE_KEY => 'decimal',
                        Column::ORDER_KEY => 0,
                        Column::MODIFIER_KEY => null,
                        Column::OPERATION_KEY => null, // todo multiply
                    ],
                    [
                        Brackets::CATEGORY_KEY => Brackets::CATEGORY,
                        Brackets::TYPE_KEY => 'decimal',
                        Brackets::ORDER_KEY => 1,
                        Brackets::MODIFIER_KEY => null,
                        Brackets::OPERATION_KEY => null, // todo divide
                        Brackets::ELEMENTS_KEY => [
                            [
                                Column::CATEGORY_KEY => Column::CATEGORY,
                                Column::COLUMN_ID => 'order_item.qty_invoiced',
                                Column::TYPE_KEY => 'decimal',
                                Column::ORDER_KEY => 0,
                                Column::MODIFIER_KEY => null,
                                Column::OPERATION_KEY => null,// todo minus
                            ],
                            [
                                Column::CATEGORY_KEY => Column::CATEGORY,
                                Column::COLUMN_ID => 'order_item.qty_backordered',
                                Column::TYPE_KEY => 'decimal',
                                Column::ORDER_KEY => 1,
                                Column::MODIFIER_KEY => null,
                                Column::OPERATION_KEY => null,
                            ],
                        ]
                    ],
                    [
                        Input::CATEGORY_KEY => Input::CATEGORY,
                        Input::VALUE_KEY => 2,
                        Input::TYPE_KEY => 'decimal',
                        Input::ORDER_KEY => 2,
                        Input::MODIFIER_KEY => null,
                        Input::OPERATION_KEY => null,
                    ],
                ],
                ReportVirtualColumnInterface::DATA_TYPE => 'decimal'
            ]
        ]
    ],
    [
        ReportColumnInterface::REPORT_ID => $reportId,
        ReportColumnInterface::COLUMN_ID => 'virtual_2',
        ReportColumnInterface::EXTENSION_ATTRIBUTES_KEY => [
            ReportVirtualColumnInterface::EXTENDED_KEY => [
                ReportVirtualColumnInterface::CONTEXT => [
                    [
                        Column::CATEGORY_KEY => Column::CATEGORY,
                        Column::COLUMN_ID => 'order_item.sku',
                        Column::TYPE_KEY => 'string',
                        Column::ORDER_KEY => 0,
                        Column::MODIFIER_KEY => null,
                        Column::OPERATION_KEY => null,
                    ]
                ],
                ReportVirtualColumnInterface::DATA_TYPE => 'string'
            ]
        ]
    ]
];

$allColumns = $report->getAllColumns();
foreach ($columnsData as $columnData) {
    $allColumns[$columnData[ReportColumnInterface::COLUMN_ID]] = $columnData;
}
$report->setColumns($allColumns);

$reportRepository->save($report);
